<?php
require_once("../layouts/members/head.php");

/* =====================================
   NEW PAN DETAILS PRIME PLUS API
   ===================================== */
function panDetailsPrememium_run_new($request)
{
    $panNumber = strtoupper($request['panNumber']);
    $api_key   = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

    $url = "https://kycapizone.in/api/v2/pan_advance/pan_perime_plus.php"
         . "?api_key={$api_key}&pan_number={$panNumber}";

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    // ✅ SUCCESS STATUS = 100
    if (isset($res['status']) && (string)$res['status'] === '100') {

        $r = $res['result'] ?? [];

        return [
            'status'        => '100',
            'panNumber'     => $r['panNumber'] ?? '',
            'name'          => $r['name'] ?? '',
            'fathername'    => $r['fatherName'] ?? '',
            'dob'           => $r['dob'] ?? '',
            'gender'        => $r['gender'] ?? '',
            'aadhar'        => $r['maskedAadhaar'] ?? '',
            'mobileNumber'  => $r['mobileNumber'] ?? '',
            'emailId'       => $r['emailId'] ?? '',
            'address'       => $r['address'] ?? '',
        ];
    } else {
        return [
            'status' => '101',
            'error'  => $res['message'] ?? 'API Error'
        ];
    }
}

/* =====================================
   MAIN PAGE
   ===================================== */

$panNumber = '';
$response  = [];

if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
<?php if ($user_data['pandetils_service'] == "YES") { ?>
<div class="col-md-4 mb-2">
<div class="card text-danger">
<div class="card-header bg-primary text-white py-2">
<div class="d-flex align-items-center">
<span class="mr-auto"><?= file_name() ?></span>
<button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
<i class="fas fa-arrow-left"></i> Back
</button>
</div>
</div>

<div class="p-3 text-dark">
<?php
if (isset($_POST['submit'])) {

    $panNumber = is_valid_pan($_POST['panNumber']);

    if (!empty($panNumber)) {

        $amount      = $user_data['pandetils_fee'];
        $old_balance = $user_data['balance'];
        $new_balance = $old_balance - $amount;

        if ($old_balance >= $amount) {

            $order_id = order_txn_id();

            // 🔥 CALL NEW API
            $response = panDetailsPrememium_run_new([
                'panNumber' => $panNumber,
                'order_id'  => $order_id
            ]);

            if (isset($response['status']) && $response['status'] == '100') {

                db_update(
                    "members",
                    ["balance" => $new_balance],
                    " user_id='{$user_data['user_id']}' "
                );

                db_insert("reports", [
                    'site_id'        => $site_data['site_id'],
                    'user_id'        => $user_data['user_id'],
                    'username'       => $user_data['username'],
                    'name'           => $user_data['name'],
                    'operator'       => $user_data['usertype'],
                    'parent_id'      => $user_data['parent_id'],
                    'order_id'       => $order_id,
                    'service'        => "PANDETAILS",
                    'type'           => "Debit",
                    'account_number' => $panNumber,
                    'app_type'       => "PANDETAILS",
                    'amount'         => $amount,
                    'main_amount'    => $amount,
                    'old_balance'    => $old_balance,
                    'new_balance'    => $new_balance,
                    'txn_id'         => $order_id,
                    'ref_id'         => $response['name'],
                    'description'    => "Rs.{$amount} Debited for PAN Details {$panNumber}",
                    'date_time'      => current_timestamp(),
                    'status'         => "Success"
                ]);

                // SMS
                $whamessage = "Dear {$user_data['name']},\n"
                            . "Your PAN Details request completed.\n\n"
                            . "Name: {$response['name']}\n"
                            . "DOB: {$response['dob']}\n"
                            . "Gender: {$response['gender']}\n\n"
                            . "{$site_data['brand']}";

                send_sms($user_data['mobile'], $whamessage);

            } else {
                awal_alert_msg($response['error'], 'error');
            }
        } else {
            awal_alert_msg("Insufficient Wallet Balance!", 'error');
        }
    } else {
        awal_alert_msg("Invalid PAN Number!", 'error');
    }
}
?>

<form method="POST" class="row">
<div class="col-md-12 mb-3">
<label>PAN Number</label>
<input type="text" name="panNumber"
maxlength="10"
class="form-control"
placeholder="ABCDE1234F"
oninput="this.value=this.value.toUpperCase()"
pattern="^[A-Z]{5}[0-9]{4}[A-Z]$"
required>
</div>

<div class="col-md-12 mb-3 d-flex justify-content-between">
<button type="button" class="btn btn-secondary">
<i class="fas fa-inr"></i> <?= $user_data['pandetils_fee']; ?>
</button>

<button type="submit" name="submit"
class="btn btn-primary"
onclick="return confirm('Are you sure?');">
Submit
</button>

<button type="button" class="btn btn-warning"
data-toggle="modal" data-target="#showDetailsModal">
Show
</button>
</div>
</form>
</div>
</div>
</div>
<?php } ?>
</div>

<!-- ================= MODAL ================= -->
<div class="modal fade" id="showDetailsModal">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Fetched Details</h5>
<button class="close" data-dismiss="modal">&times;</button>
</div>

<div class="modal-body">
<?php if (!empty($response['name'])) { ?>
<input class="form-control mb-2" value="<?= htmlspecialchars($panNumber) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['name']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['dob']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['fathername']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['gender']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['aadhar']) ?>" readonly>
<input class="form-control mb-2" value="<?= htmlspecialchars($response['address']) ?>" readonly>
<?php } else { ?>
<p>No details fetched yet.</p>
<?php } ?>
</div>

<div class="modal-footer">
<button class="btn btn-danger" data-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<script>
<?php if (!empty($response['name'])) { ?>
$(document).ready(function(){
    $('#showDetailsModal').modal('show');
});
<?php } ?>
</script>

<?php
} else {
require_once("404.php");
}
require_once("../layouts/members/foot.php");
?>
